/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogMarkerBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.AndBlock;
import DE.siemens.ad.logo.model.block.NandBlock;
import DE.siemens.ad.logo.model.block.NorBlock;
import DE.siemens.ad.logo.model.block.OrBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.PecAndBlock;
import DE.siemens.ad.logo.model.block.PecNandBlock;
import DE.siemens.ad.logo.model.block.VirtualOutputBlock;
import DE.siemens.ad.logo.model.block.XorBlock;
import DE.siemens.ad.logo.model.hardware.Logo4;
import DE.siemens.ad.logo.model.visitor.build.CompilerToLogo;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo4;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.Memory16;
import DE.siemens.ad.logo.util.ProgramMemory16;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import java.util.Enumeration;

public class CompilerToLogo4
extends CompilerToLogo {
    protected static final int START_PROGRAMLINE_COUNT = 10;
    protected static final int START_PROGRAMLINE_LENGTH = 20;
    public static final int ANCHOR_MEMORY_LENGTH = 200;
    protected ProgramMemory16 fProgramMemory = null;
    protected Memory16 fProgramOffsetTable = null;

    public void init() {
        super.init();
        ((LinkerToLogo4)this.fLinker).setCompiler(this);
        this.fProgramMemory = (ProgramMemory16)((Logo4)this.fHardware).getMemory("Program");
        this.fProgramOffsetTable = (Memory16)((Logo4)this.fHardware).getMemory("ProgOffsetTabelle");
        this.initOffsetTableForStartProgramLine();
        ((Logo4)this.fHardware).getMemory("BlocknamenTabelle").init(255);
        ((Logo4)this.fHardware).getMemory("Blocknamen").init(255);
    }

    protected void initOffsetTableForStartProgramLine() {
        this.fProgramOffsetTable.init(255);
        for (int i = 0; i < 10; ++i) {
            this.fProgramOffsetTable.putWord(i * 20);
        }
    }

    public void compile(WiringDiagram wd, Hardware hw) {
        super.compile(wd, hw);
        Memory blockNameOffsetTable = ((Logo4)hw).getMemory("BlocknamenTabelle");
        Memory blockNamesTable = ((Logo4)hw).getMemory("Blocknamen");
        Enumeration enumeration = wd.getBlocks().elements();
        int blockIndex = 0;
        while (enumeration.hasMoreElements()) {
            Block block = (Block)enumeration.nextElement();
            if (!block.isUserDefinedNameAvailable() || block.getNumberType() != 0) continue;
            blockNamesTable.setPosition(blockIndex, 0);
            ++blockIndex;
            this.putNameOffsetTable(blockNameOffsetTable, this.fLinker.convertToPrgLine(block.getNumber()));
            byte[] namesArr = block.getUserDefinedName().getBytes();
            for (int i = 0; i < namesArr.length; ++i) {
                blockNamesTable.put(namesArr[i]);
            }
            if (namesArr.length >= blockNamesTable.getBlockSize()) continue;
            blockNamesTable.put(0);
        }
    }

    protected void putNameOffsetTable(Memory blockNameOffsetTable, int progLineNumber) {
        blockNameOffsetTable.put(progLineNumber);
    }

    protected void setAnchor(OutputBlock block, String memoryID) {
        int anchorNumber = block.getNumber();
        int blockIndex = (anchorNumber - 1) / 8;
        int byteIndex = (anchorNumber - 1) % 8 * 2 + 2;
        Memory memory = this.getMemory(memoryID);
        memory.setPosition(blockIndex, byteIndex);
        this.link(block, memory);
    }

    public Object visit(VirtualOutputBlock block) {
        this.setAnchor(block, "Virtuelle Anker");
        return null;
    }

    public Object visit(AnalogMarkerBlock block) {
        int anchorNumber = block.getNumber();
        int blockIndex = anchorNumber / 9;
        int byteIndex = (anchorNumber - 1) % 8 * 2 + 6;
        Memory memory = this.getMemory("Analoganker");
        memory.setPosition(blockIndex, byteIndex);
        this.link(block, memory);
        return null;
    }

    public Object visit(AnalogOutputBlock block) {
        this.setAnchor(block, "Analoganker");
        return null;
    }

    public Memory writeOpcode(Block block) {
        int opcode = block.getOpcode(this.fHardware, 0);
        this.putOffsetTable(block, opcode |= this.getOpcodeHighbyte(block.getParameter()) << 8);
        return this.fProgramMemory;
    }

    protected void putOffsetTable(Block block, int opcode) {
        this.fProgramOffsetTable.setPosition(this.fLinker.convertToPrgLine(block.getNumber()), 0);
        this.fProgramOffsetTable.putWord(this.fProgramMemory.putWord(opcode) + 200);
    }

    protected int getOpcodeHighbyte(BlockParameter param) {
        int highByte = 0;
        if (param != null) {
            if (param.getRemanenceAvailable() && param.getRemanenceObject().getRemanence()) {
                highByte |= 0x80;
            }
            if (param instanceof ProtectionParameter && !((ProtectionParameter)param).getProtection()) {
                highByte |= 0x40;
            }
            ParameterItemList itemList = param.getParameterItems().getValueOrReferenceItems().instance(param);
            for (ParameterItem item : itemList) {
                ValueOrItemReference value = (ValueOrItemReference)item.getValue();
                if (!value.isReference()) continue;
                highByte |= item.getValueOrReferenceID();
            }
        }
        return highByte;
    }

    public Object visit(AndBlock block) {
        this.visit((Block)block);
        this.fProgramMemory.putWord(65535);
        return null;
    }

    public Object visit(OrBlock block) {
        this.visit((Block)block);
        this.fProgramMemory.putWord(65535);
        return null;
    }

    public Object visit(NandBlock block) {
        this.visit((Block)block);
        this.fProgramMemory.putWord(65535);
        return null;
    }

    public Object visit(NorBlock block) {
        this.visit((Block)block);
        this.fProgramMemory.putWord(65535);
        return null;
    }

    public Object visit(XorBlock block) {
        this.visit((Block)block);
        this.fProgramMemory.putWord(65535);
        return null;
    }

    public Object visit(PecAndBlock block) {
        this.visit((Block)block);
        this.fProgramMemory.putWord(65535);
        return null;
    }

    public Object visit(PecNandBlock block) {
        this.visit((Block)block);
        this.fProgramMemory.putWord(65535);
        return null;
    }
}

